package com.easesource.iot.protoparser.base.cache;

import io.netty.channel.Channel;

import java.util.concurrent.ConcurrentHashMap;

public class ChannelIdRtuIdCache {
    private static volatile ConcurrentHashMap<String, Integer> cacheMap;

    private ChannelIdRtuIdCache(){}

    public static ConcurrentHashMap<String, Integer> getCacheMap(){
        if(cacheMap == null){
            synchronized (DcuIdChannelCache.class){
                if(cacheMap == null){
                    cacheMap = new ConcurrentHashMap<String, Integer>();
                }
            }
        }
        return cacheMap;
    }

    public static void putCache(String channelId,Integer rtuId){
        getCacheMap().put(channelId,rtuId);
    }

    public static void removeCache(String channelId){
        getCacheMap().remove(channelId);
    }


    public  static Integer  getKeyCache(String channelId){
        Integer rtuId= getCacheMap().get(channelId);
        return rtuId;
    }
}
