package com.easesource.iot.protoparser.base.cache;



import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 保存数据采集器连接到服务端的channel
 */
public class DcuIdChannelCache {
    private static volatile  ConcurrentHashMap<Integer, Channel> cacheMap;

    private DcuIdChannelCache(){}

    public static ConcurrentHashMap<Integer,Channel> getCacheMap(){
        if(cacheMap == null){
            synchronized (DcuIdChannelCache.class){
                if(cacheMap == null){
                    cacheMap = new ConcurrentHashMap<Integer, Channel>();
                }
            }
        }
        return cacheMap;
    }

    public static void putCache(Integer key,Channel channel){
        getCacheMap().put(key,channel);
    }

    public static void removeCache(Integer key){
        getCacheMap().remove(key);
    }

    public  static Channel  getCache(Integer key,Channel defaultchannel){
        Channel channel = getCacheMap().get(key);
        return channel == null ? defaultchannel : channel;
    }

    public  static Channel  getKeyCache(Integer  key){
        Channel channel = getCacheMap().get(key);
        return channel;
    }

}
