package com.easesource.iot.protoparser.base.utils;

import java.nio.ByteBuffer;
import java.util.List;

public class BytesUtil {

    /**
     * 三个字节拼接
     * @param bt1
     * @param bt2
     * @param bt3
     * @return
     */
    public static byte[] byte3Merger(byte[] bt1,byte[] bt2,byte[] bt3){
        byte[] bt = new byte[bt1.length+bt2.length+bt3.length];
        System.arraycopy(bt1,0,bt,0,bt1.length);
        System.arraycopy(bt2,0,bt,bt1.length,bt2.length);
        System.arraycopy(bt3,0,bt,bt1.length+bt2.length,bt3.length);
        return bt;
    }
    public static byte[] byte4Merger(byte[] bt1,byte[] bt2,byte[] bt3,byte[] byt4){
        byte[] bt = new byte[bt1.length+bt2.length+bt3.length+byt4.length];
        System.arraycopy(bt1,0,bt,0,bt1.length);
        System.arraycopy(bt2,0,bt,bt1.length,bt2.length);
        System.arraycopy(bt3,0,bt,bt1.length+bt2.length,bt3.length);
        System.arraycopy(byt4,0,bt,bt1.length+bt2.length+bt3.length,byt4.length);
        return bt;
    }

    public static byte[] byte5Merger(byte[] bt1,byte[] bt2,byte[] bt3,byte[] bt4,byte[] bt5){
        byte[] bt = new byte[bt1.length+bt2.length+bt3.length+bt4.length+bt5.length];
        System.arraycopy(bt1,0,bt,0,bt1.length);
        System.arraycopy(bt2,0,bt,bt1.length,bt2.length);
        System.arraycopy(bt3,0,bt,bt1.length+bt2.length,bt3.length);
        System.arraycopy(bt4,0,bt,bt1.length+bt2.length+bt3.length,bt4.length);
        System.arraycopy(bt5,0,bt,bt1.length+bt2.length+bt3.length+bt4.length,bt5.length);
        return bt;
    }
    public static byte[] bytenMerger(List<byte[]> list){
        int initLength = 0;
        for(int i=0;i<list.size();i++){
            initLength+=list.get(i).length;
        }
        byte[] result = new byte[initLength];
        int length = 0;
        for(int i=0; i<list.size();i++){
            System.arraycopy(list.get(i),0,result,length,list.get(i).length);
            length +=list.get(i).length;
        }
        return result;
    }
    /**
     * 二个字节拼接
     * @param bt1
     * @param bt2
     * @return
     */
    public static byte[] byteMerger(byte[] bt1,byte[] bt2){
        byte[] bt3 = new byte[bt1.length+bt2.length];
        System.arraycopy(bt1,0,bt3,0,bt1.length);
        System.arraycopy(bt2,0,bt3,bt1.length,bt2.length);
        return bt3;
    }

    /**
     *   截取目标长度的字节数组 如果剩下不足指定长度，就得到剩下的字节数组
     * @param target
     * @param start
     * @param length
     * @return
     */
    public static byte[] getSubBytes(byte[] target , int start , int length){
        int len = target.length;
        byte[] result = null;
        int remainLen = len - start;
        if(remainLen >= 0) {
            if (remainLen >= length) {
                result = new byte[length];
                System.arraycopy(target, start, result, 0, length);
            } else {
                result = new byte[remainLen];
                System.arraycopy(target, start, result, 0, remainLen);
            }
        }
        return result;
    }
    /**
     * 16进制 String 转字节数组
     * @param
     * @return
     */
    public static byte[] stringToByte(String hexstring){
        byte[] destByte = new byte[hexstring.length()/2];
        int j=0;
        for(int i=0;i<destByte.length;i++) {
            byte high = (byte) (Character.digit(hexstring.charAt(j), 16) & 0xff);
            byte low = (byte) (Character.digit(hexstring.charAt(j + 1), 16) & 0xff);
            destByte[i] = (byte) (high << 4 | low);
            j+=2;
        }
        return destByte;
    }

    /**
     * 数组反向
     * @param data
     * @return
     */
    public static byte[] byteToByte(byte[] data){
        byte[] result = new byte[data.length];
        int j = 0;
        for(int i=data.length-1;i>=0;i--){
            result[j] = data[i];
            j++;
        }
        return result;
    }

    /**
     * byte数组 合并 byte
     * @param data
     * @param b
     * @return
     */
    public static byte[] bytesAndbyte(byte[] data,byte b){
        byte[] result = new byte[data.length+1];
        for(int i=0;i<data.length;i++){
            result[i]=data[i];
        }
        result[data.length] = b;
        return  result;
    }

    /**
     * 提供得到一个字节
     * @return
     */
    public static byte StringTobyte(String s){
        byte[] bytes = stringToByte(s);
        return bytes[0];
    }

    /**
     * 将float转换成byte数组
     * @param f
     * @return
     */
    public static byte[] float2byte(float f) {

        // 把float转换为byte[]
        int fbit = Float.floatToIntBits(f);

        byte[] b = new byte[4];
        for (int i = 0; i < 4; i++) {
            b[i] = (byte) (fbit >> (24 - i * 8));
        }

        // 翻转数组
        int len = b.length;
        // 建立一个与源数组元素类型相同的数组
        byte[] dest = new byte[len];
        // 为了防止修改源数组，将源数组拷贝一份副本
        System.arraycopy(b, 0, dest, 0, len);
        byte temp;
        // 将顺位第i个与倒数第i个交换
        for (int i = 0; i < len / 2; ++i) {
            temp = dest[i];
            dest[i] = dest[len - i - 1];
            dest[len - i - 1] = temp;
        }
        return dest;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(Long.BYTES);
        buffer.putLong(x);
        return buffer.array();
    }
    public static byte[] floatToBytes(float x) {
        ByteBuffer buffer = ByteBuffer.allocate(Float.BYTES);
        buffer.putFloat(x);
        return buffer.array();
    }

    /**
     *
     * @param x
     * @return
     */
    public static byte[] intToBytes(int x){
        ByteBuffer buffer = ByteBuffer.allocate(Integer.BYTES);
        buffer.putInt(x);
        return buffer.array();
    }

    public static byte[] intTotn3Bytes(String s){
        byte[] b = intToBytes(Integer.valueOf(s));
        byte[] result = new byte[3];
        int a = 0;
        for(int i=3;i >= 1;i--){
            result[a] = b[i];
            a +=1;
        }
        return result;
    }

    /**
     * 一个不超过15的int转换成4字节前面补0
     * @param n
     * @return
     */
    public static byte[] intTotn4Bytes(byte n){
        byte[] result = new byte[4];
        result[3] = n;
        return result;
    }
    /**
     *
     * @param x
     * @return
     */
    public static byte[] shortToBytes(short x){
        ByteBuffer buffer = ByteBuffer.allocate(Short.BYTES);
        buffer.putShort(x);
        return buffer.array();
    }

    public static byte[] ASCIIToBytes(String s){
        char[] charArrays = s.toCharArray();
        byte[] result = new byte[charArrays.length];
        for(int i=0;i<charArrays.length;i++){
            result[i] = (byte) charArrays[i];
        }
        return result;
    }

    /**
     * 将ASCII码返回指定字节，不够长度左边补充
     * @param s
     * @param n
     * @return
     */
    public static byte[] ASCIIToNBytes(String s,int n){
        char[] charArrays = s.toCharArray();
        byte[] asciiBytes = new byte[charArrays.length];
        byte[] result ;
        byte[] zeroBytes = new byte[n-charArrays.length];
        for(int i=0;i<charArrays.length;i++){
            asciiBytes[i] = (byte) charArrays[i];
        }
        result = BytesUtil.byteMerger(zeroBytes,asciiBytes);
        return result;
    }
    /**
     * 得到  mbus的验证码
     * @param data
     * @return
     */
    public static String getCheckCode(byte[] data){
        int sum = 0;
        for(byte b:data){
            sum+=b;
        }
        byte result = (byte) (sum&0xFF);
        return HexDump.toHex(result);
    }
    public static byte[] hexStringTobytes(String s,String sign){
        byte[] result = new byte[0];
        while(s.indexOf(sign) > 0){
          byte[] b = BytesUtil.stringToByte(s.substring(0,s.indexOf(sign)));
          s = s.substring(s.indexOf(sign)+1);
          result = BytesUtil.byteMerger(result,b);
        }
        byte[] c = BytesUtil.stringToByte(s);
        result = BytesUtil.byteMerger(result,c);
        return result;
    }
    public static byte[] checkAndHexStringTobytes(String s){
        String regex = "^[A-Fa-f0-9]+$";
        byte[] data = null;
        if(s.matches(regex)){
            if(s.length() % 2 == 0){
                data = BytesUtil.stringToByte(s);
            }
        }
        return data;
    }
    /**
     *
     * @param s
     * @param sign
     * @return
     */
    public static byte[] asciiStringTobytes(String s,String sign){
        byte[] result = new byte[0];
        while(s.indexOf(sign) > 0){
            byte[] b = BytesUtil.ASCIIToBytes(s.substring(0,s.indexOf(sign)));
            s = s.substring(s.indexOf(sign)+1);
            result = BytesUtil.byteMerger(result,b);
        }
        byte[] c = BytesUtil.ASCIIToBytes(s);
        result = BytesUtil.byteMerger(result,c);
        return result;
    }


    public static void main(String[] args) {
//       byte[] bytes = stringToByte("682016100107162000812E1F900099999F9DFDF06759E1059999999170000000035916310002C20230020230054820206441725091920C0001F16");
//       for(byte b:bytes){
//           System.out.println(b);
//       }
//        byte[] target = {1,2,3,4};
////        int start = 2;
////        int len = 5;
////        byte[] result = getSubBytes(target,start,len);
////        for(byte b:result){
////            System.out.println(b);
////        }
        byte[] data = checkAndHexStringTobytes("04037D1000185C3C");
        for(byte b:data){
            System.out.print(HexDump.toHex(b));
        }
    }
}
