/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.utils;

import com.easesource.iot.protoparser.base.utils.BytesUtil;
import java.util.Calendar;
import java.util.Date;

public class ParseUtils {
    public static Date readTime(byte[] bytes) {
        if (bytes == null || bytes.length != 6) {
            throw new IllegalArgumentException("time bytes length != 6");
        }
        int seconds = bytes[0] & 0x3F;
        seconds = seconds > 59 ? 59 : seconds;
        int minute = bytes[1] & 0x3F;
        minute = minute > 59 ? 59 : minute;
        int hour = bytes[2] & 0x1F;
        hour = hour > 23 ? 23 : hour;
        int day = bytes[3] & 0x1F;
        int month = bytes[4] & 0xF;
        month = month > 12 ? 12 : month;
        int year = 2000 + (bytes[5] & 0x7F);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, seconds);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static int[] readStatus(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes length <=0");
        }
        int[] status = new int[8 * bytes.length];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < bytes.length; ++j) {
                status[i + 8 * j] = bytes[j] >> i & 1;
            }
        }
        return status;
    }

    public static int readBit(byte bt, int position) {
        if (position < 0 || position >= 8) {
            throw new IllegalArgumentException("position range 0-7");
        }
        return bt >> position & 1;
    }

    public static byte[] dateToByte(Date date) {
        byte[] result = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(10);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millis = cal.get(14);
        int milliseconds = second * 1000 + millis;
        int yr = year - 2000;
        System.out.println("\u5e74" + year + "\u6708" + month + "\u65e5" + day + "\u5c0f\u65f6" + hour + "\u5206" + minute + "\u6beb\u79d2" + milliseconds);
        byte[] millisecondsBytes = ParseUtils.intTo2Byte(milliseconds);
        byte[] datetime = new byte[]{(byte)minute, (byte)hour, (byte)day, (byte)month, (byte)yr};
        result = BytesUtil.byteMerger(millisecondsBytes, datetime);
        return result;
    }

    public static byte[] intTo2Byte(int data) {
        byte[] byteArray = new byte[]{(byte)data, (byte)(data >> 8)};
        return byteArray;
    }

    public static void main(String[] args) {
    }
}

