package com.easesource.iot.protoparser.base.cache;

import io.netty.channel.Channel;

import java.util.concurrent.ConcurrentHashMap;

public class ChannelIpPortCache {
    private static volatile ConcurrentHashMap<Channel, String> cacheMap;

    private ChannelIpPortCache(){}

    public static ConcurrentHashMap<Channel, String> getCacheMap(){
        if(cacheMap == null){
            synchronized (DcuIdChannelCache.class){
                if(cacheMap == null){
                    cacheMap = new ConcurrentHashMap<Channel, String>();
                }
            }
        }
        return cacheMap;
    }

    public static void putCache(Channel channel,String ipAndPort){
        getCacheMap().put(channel,ipAndPort);
    }

    public static void removeCache(Channel channel){
        getCacheMap().remove(channel);
    }


    public  static String  getKeyCache(Channel channel){
        String ipAndPort= getCacheMap().get(channel);
        return ipAndPort;
    }
}
