/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.thread;

import com.easesource.iot.protoparser.base.thread.PerformanceMethod;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseThreadPool<T>
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<T> queue = new ConcurrentLinkedDeque<T>();
    protected ThreadPoolExecutor threadPool = null;
    protected Thread thread;
    protected int poolMinSize = 128;
    protected int poolMaxSize = 128;
    protected int poolQueueSize = 128;
    protected int keepAliveTime = 60;
    private ArrayBlockingQueue<Runnable> threadBlockingQueue;

    public boolean init() {
        this.threadPool = new ThreadPoolExecutor(this.poolMinSize, this.poolMaxSize, this.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        return true;
    }

    public boolean start() {
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    public void destory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T o) {
        boolean bRet = this.queue.offer(o);
        Queue<T> queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeData(long timeout) {
        if (this.queue.isEmpty()) {
            Queue<T> oldQueue;
            Queue<T> queue = oldQueue = this.queue;
            synchronized (queue) {
                try {
                    oldQueue.wait(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.queue.poll();
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolSize) {
        this.poolMinSize = poolSize;
        if (this.threadPool != null) {
            this.threadPool.setCorePoolSize(this.poolMinSize);
        }
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
        if (this.threadPool != null) {
            this.threadPool.setMaximumPoolSize(poolMaxSize);
        }
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        if (this.threadPool != null) {
            this.threadPool.setKeepAliveTime(keepAliveTime, TimeUnit.SECONDS);
        }
    }

    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    public void setPoolQueueSize(int poolQueueSize) {
        this.poolQueueSize = poolQueueSize;
        this.resetThreadPoolParam();
    }

    public int getWaitCount() {
        return this.threadBlockingQueue.size();
    }

    @PerformanceMethod(value="\u5f53\u524d\u6fc0\u6d3b\u7ebf\u7a0b\u6570")
    public int getActiveCount() {
        return this.threadPool == null ? 0 : this.threadPool.getActiveCount();
    }

    @PerformanceMethod(value="\u5df2\u7ecf\u5b8c\u6210\u4efb\u52a1\u6570")
    public long getCompletedTaskCount() {
        return this.threadPool == null ? 0L : this.threadPool.getCompletedTaskCount();
    }

    @PerformanceMethod(value="\u6700\u5927\u7ebf\u7a0b\u6570")
    public int getLargestPoolSize() {
        return this.threadPool == null ? 0 : this.threadPool.getLargestPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetThreadPoolParam() {
        if (this.threadPool != null) {
            ThreadPoolExecutor threadPoolExecutor = this.threadPool;
            synchronized (threadPoolExecutor) {
                this.log.warn("\u7ebf\u7a0b\u6c60\u53c2\u6570\u88ab\u4fee\u6539\uff0c\u505c\u6b62\u539f\u6709\u7ebf\u7a0b\u6c60");
                this.threadPool.shutdown();
                this.threadPool = new ThreadPoolExecutor(this.poolMinSize, this.poolMaxSize, this.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
                this.log.warn("\u542f\u7528\u65b0\u7684\u7ebf\u7a0b\u6c60\uff0cpoolMinSize\uff1a{}\uff0cpoolMaxSize\uff1a{}\uff0ckeepAliveTime\uff1a{}\u79d2", new Object[]{this.poolMinSize, this.poolMaxSize, this.keepAliveTime});
            }
        }
    }
}

