/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.commons.util.NumberUtils;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseMDataDecoder {
    private static final Logger log = LoggerFactory.getLogger(BaseMDataDecoder.class);

    BaseMDataDecoder() {
    }

    abstract void decode(ByteBuf var1, MBusCommand var2);

    public static double getDPower(ByteBuf buf) {
        int readableBytes = buf.readableBytes();
        double tPower = 0.0;
        if (readableBytes >= 5) {
            tPower = BaseMDataDecoder.fiveByteToDouble(buf);
            if (tPower == 999999.99) {
                return 0.0;
            }
        } else {
            log.error("dPower byte Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return tPower;
    }

    public static double getCColdEnergy(ByteBuf buf) {
        int readableBytes = buf.readableBytes();
        double tPower = 0.0;
        if (readableBytes >= 5) {
            tPower = BaseMDataDecoder.fiveByteToDouble(buf);
        } else {
            log.error("cColdEnergy byte Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return tPower;
    }

    public static double getCHeat(ByteBuf buf) {
        int num = buf.readableBytes();
        double cHeat = 0.0;
        if (num >= 5) {
            cHeat = BaseMDataDecoder.fiveByteToDouble(buf);
        } else {
            log.error("cHeat byte Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return cHeat;
    }

    public static double getTPower(ByteBuf buf) {
        int num = buf.readableBytes();
        double tPower = 0.0;
        if (num >= 5) {
            tPower = BaseMDataDecoder.fiveByteToDouble(buf);
        } else {
            log.error("tPower byte Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return tPower;
    }

    public static double getFlow(ByteBuf buf) {
        int num = buf.readableBytes();
        double flow = 0.0;
        if (num >= 5) {
            flow = BaseMDataDecoder.fiveByteToD(buf);
        } else {
            log.error("flow Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return flow;
    }

    public static double getCAFlow(ByteBuf buf) {
        int num = buf.readableBytes();
        double cAflow = 0.0;
        if (num >= 5) {
            cAflow = BaseMDataDecoder.fiveByteToDouble(buf);
        } else {
            log.error("cAflow byte Length:5 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return cAflow;
    }

    public static double getSWTemperature(ByteBuf buf) {
        int num = buf.readableBytes();
        double sWTemperature = 0.0;
        if (num >= 3) {
            sWTemperature = BaseMDataDecoder.threeByteToDouble(buf);
        } else {
            log.error("sWTemperature byte Length:3 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return sWTemperature;
    }

    public static double getRWTemperature(ByteBuf buf) {
        int num = buf.readableBytes();
        double rWTemperature = 0.0;
        if (num >= 3) {
            rWTemperature = BaseMDataDecoder.threeByteToDouble(buf);
        } else {
            log.error("rWTemperature byte Length:3 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return rWTemperature;
    }

    public static double getTemperature(ByteBuf buf) {
        int num = buf.readableBytes();
        double temperature = 0.0;
        if (num >= 2) {
            temperature = BaseMDataDecoder.twoByreToDouble(buf);
        } else {
            log.error("temperature byte Length:3 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return temperature;
    }

    public static int getAWTime(ByteBuf buf) {
        int num = buf.readableBytes();
        int aWTime = 0;
        if (num >= 3) {
            aWTime = BaseMDataDecoder.threeByteToInt(buf);
        } else {
            log.error("aWTime byte Length:3 Error,Data : " + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return aWTime;
    }

    public static Date getRealTime(ByteBuf buf) {
        Date date = null;
        int num = buf.readableBytes();
        if (num >= 7) {
            date = BaseMDataDecoder.readTime(buf);
        } else {
            log.error("realTime byte Length:7 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return date;
    }

    public static void getAndSetST(ByteBuf buf, MData mdata) {
        int D7Value;
        int D6Value;
        int D5Value;
        byte ST0 = buf.readByte();
        byte ST1 = buf.readByte();
        mdata.setmDByte(ST1);
        int D0D1Value = ST0 & 3;
        if (D0D1Value == 0) {
            mdata.setValveStatus("open");
        } else if (D0D1Value == 1) {
            mdata.setValveStatus("close");
        } else if (D0D1Value == 3) {
            mdata.setValveStatus("exp");
        } else {
            log.error(" Error,ST byte:" + ST0);
        }
        int D2Value = ST0 & 4;
        if (D2Value == 4) {
            mdata.setbVStatus(true);
        }
        if ((D5Value = ST0 & 0x20) == 32) {
            mdata.setpFStatus(true);
        }
        if ((D6Value = ST0 & 0x40) == 64) {
            mdata.setrHStatus(true);
        }
        if ((D7Value = ST0 & 0x80) == 128) {
            mdata.setrCStatus(true);
        }
    }

    public static void getAndSetWriteST(ByteBuf buf, MData mdata) {
        int d7Value;
        int d4d5Value;
        int d3Value;
        byte ST = buf.readByte();
        int d1d0Value = ST & 3;
        if (d1d0Value == 0) {
            mdata.setValveStatus("open");
        } else if (d1d0Value == 1) {
            mdata.setValveStatus("close");
        } else if (d1d0Value == 3) {
            mdata.setValveStatus("exp");
        } else {
            log.error(" Error,ST byte:" + ST);
        }
        int d2Value = ST & 4;
        if (d2Value == 4) {
            mdata.setValueSwitch(true);
        }
        if ((d3Value = ST & 8) == 8) {
            mdata.setePowerStatus(true);
        }
        if ((d4d5Value = ST & 0x30) == 48) {
            mdata.setSwitchStatus("broken");
        } else if (d4d5Value == 32) {
            mdata.setSwitchStatus("short");
        } else if (d4d5Value == 0) {
            mdata.setSwitchStatus("normal");
        }
        int d6Value = ST & 0x40;
        if (d6Value == 64) {
            mdata.setRoomCCStatus(true);
        }
        if ((d7Value = ST & 0x80) == 128) {
            mdata.setRoomTStatus(true);
        }
    }

    public static int getCount(ByteBuf buf) {
        int num = buf.readableBytes();
        int count = 0;
        if (num > 3) {
            count = BaseMDataDecoder.threeByteToInt(buf);
        } else {
            log.error("openOrCloseCount byte Length:3 Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
        return count;
    }

    public static void getAndSet80ST(ByteBuf buf, MData mdata) {
        int flowSSValue;
        int rWTSValue;
        int wITSValue;
        int integraphValue;
        byte ST2 = buf.readByte();
        byte ST1 = buf.readByte();
        int bVValue = ST2 & 4;
        if (bVValue == 4) {
            mdata.setbVStatus(true);
        }
        if ((integraphValue = ST1 & 1) == 1) {
            mdata.setIntegraphStatus(true);
        }
        if ((wITSValue = ST1 & 2) == 2) {
            mdata.setwITSStatus(true);
        }
        if ((rWTSValue = ST1 & 4) == 4) {
            mdata.setrWTSStatus(true);
        }
        if ((flowSSValue = ST1 & 8) == 8) {
            mdata.setFlowSSstatus(true);
        }
    }

    public static double fiveByteToDouble(ByteBuf buf) {
        double result = 0.0;
        byte decimal = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte one = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte two = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte three = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        buf.skipBytes(1);
        result = (double)decimal / 100.0 + (double)one + (double)(two * 100) + (double)(three * 10000);
        return result;
    }

    public static double fiveByteToD(ByteBuf buf) {
        double result = 0.0;
        byte decimalPoint = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte percentile = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte one = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte two = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        buf.skipBytes(1);
        result = (double)decimalPoint / 10000.0 + (double)percentile / 100.0 + (double)one + (double)(two * 100);
        return result;
    }

    public static double threeByteToDouble(ByteBuf buf) {
        byte percentile = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte one = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte two = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        double result = (double)percentile / 100.0 + (double)one + (double)(two * 100);
        return result;
    }

    public static double twoByreToDouble(ByteBuf buf) {
        byte percentile = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte one = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        double result = (double)percentile / 100.0 + (double)one;
        return NumberUtils.toScaledBigDecimal((Double)result, (int)8, (RoundingMode)RoundingMode.valueOf(4)).doubleValue();
    }

    public static int threeByteToInt(ByteBuf buf) {
        int result = 0;
        byte one = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte two = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte three = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        result = one + two * 100 + three * 10000;
        return result;
    }

    public static Date readTime(ByteBuf buf) {
        byte seconds = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte minute = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte hour = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte day = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte month = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte year = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        byte hundredYear = Byte.parseByte(HexDump.toHex((byte)buf.readByte()));
        int realYear = year + hundredYear * 100;
        Calendar cal = Calendar.getInstance();
        cal.set(realYear, month - 1, day, hour, minute, seconds);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static MData setSuccessfulMData(MData mData, MBusCommand cmd, String DIODI1, byte SER, double dPower, double cHeat, double tPower, double flow, double cAflow, double sWTemperature, double rWTemperature, int aWTime, Date realDate) {
        mData.setSign(DIODI1);
        mData.setSER(SER);
        mData.setdPower(dPower);
        mData.setcHeat(cHeat);
        mData.settPower(tPower);
        mData.setFlow(flow);
        mData.setcAFlow(cAflow);
        mData.setsWTemperature(sWTemperature);
        mData.setrWTemperature(rWTemperature);
        mData.setaWTime(aWTime);
        mData.setRealTime(realDate);
        mData.setStatus(0);
        cmd.setmData(mData);
        cmd.setStatus("1");
        return mData;
    }

    public static MData setSuccessMData(MData mData, MBusCommand cmd, String DIODI1, byte SER, double cColdEnergy, double cHeat, double tPower, double flow, double cAflow, double sWTemperature, double rWTemperature, int aWTime, Date realDate) {
        mData.setSign(DIODI1);
        mData.setSER(SER);
        mData.setcColdEnergy(cColdEnergy);
        mData.setcHeat(cHeat);
        mData.settPower(tPower);
        mData.setFlow(flow);
        mData.setcAFlow(cAflow);
        mData.setsWTemperature(sWTemperature);
        mData.setrWTemperature(rWTemperature);
        mData.setaWTime(aWTime);
        mData.setRealTime(realDate);
        mData.setStatus(0);
        cmd.setmData(mData);
        cmd.setStatus("1");
        return mData;
    }

    public static MData setSuccessful80MData(MData mData, MBusCommand cmd, String DIODI1, byte SER, int count, double temperature, double roomTemperature, byte version) {
        mData.setSign(DIODI1);
        mData.setSER(SER);
        mData.setCount(count);
        mData.setTemperature(temperature);
        mData.setRoomTemperature(roomTemperature);
        mData.setdVER(version);
        mData.setStatus(0);
        cmd.setmData(mData);
        cmd.setStatus("1");
        return mData;
    }

    public static MData setSuccessful84MData(MData mData, MBusCommand cmd, String DIODI1, byte SER) {
        mData.setSign(DIODI1);
        mData.setSER(SER);
        mData.setStatus(0);
        cmd.setmData(mData);
        cmd.setStatus("1");
        return mData;
    }

    public static void main(String[] args) {
        int a = 53;
        double b = (double)a / 100.0;
        System.out.println(b);
    }
}

