/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.BaseMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.IMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.IMBus;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MDataDecoder
implements IMDataDecoder {
    private static final Map<String, BaseMDataDecoder> decoderMap = new ConcurrentHashMap<String, BaseMDataDecoder>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public synchronized BaseMDataDecoder getDataItemDecoder(String flag, String code, String type) {
        String className = null;
        String newType = flag.substring(0, 2) + code + type;
        if (!decoderMap.containsKey(newType)) {
            if (code.equals("20")) {
                className = !flag.equals("111100") ? this.getClass().getPackage().getName() + ".X" + type + "MDataDecoder" : this.getClass().getPackage().getName() + ".X" + type + "Meter80ReadDecoder";
            }
            if (code.equals("80")) {
                className = this.getClass().getPackage().getName() + ".X" + type + "Meter80Decoder";
            }
            try {
                Class<?> clazz = Class.forName(className);
                BaseMDataDecoder decoder = (BaseMDataDecoder)clazz.newInstance();
                decoderMap.put(newType, decoder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return decoderMap.get(newType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decode(IMBus imBus, MBusCommand command) {
        BaseMDataDecoder decoder;
        ByteBuf buf;
        block4: {
            boolean bl;
            MBus msg = (MBus)imBus;
            byte[] data = msg.getMdata();
            if (data.length == 0) {
                return false;
            }
            String tCode = msg.gettCode();
            String flag = msg.getSite().substring(0, 6);
            buf = null;
            try {
                buf = ByteBufAllocator.DEFAULT.directBuffer(data.length);
                buf.writeBytes(data);
                decoder = this.getDataItemDecoder(flag, tCode, command.getType());
                if (decoder != null) break block4;
                this.log.warn("type:{} decode not exists", (Object)command.getType());
                bl = false;
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release(buf);
                throw throwable;
            }
            ReferenceCountUtil.release((Object)buf);
            return bl;
        }
        decoder.decode(buf, command);
        boolean bl = true;
        ReferenceCountUtil.release((Object)buf);
        return bl;
    }
}

