/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.BaseMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class X81MDataDecoder
extends BaseMDataDecoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    X81MDataDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void decode(ByteBuf buf, MBusCommand hc) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 46) {
            String DIODI1;
            MData mData = new MData();
            ByteBuf byteBuf = null;
            try {
                byteBuf = buf.readBytes(2);
                DIODI1 = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            }
            finally {
                ReferenceCountUtil.release((Object)byteBuf);
            }
            byte SER = buf.readByte();
            double dPower = X81MDataDecoder.getDPower(buf);
            double cHeat = X81MDataDecoder.getCHeat(buf);
            double tPower = X81MDataDecoder.getTPower(buf);
            double flow = X81MDataDecoder.getFlow(buf);
            double cAflow = X81MDataDecoder.getCAFlow(buf);
            double sWTemperature = X81MDataDecoder.getSWTemperature(buf);
            double rWTemperature = X81MDataDecoder.getRWTemperature(buf);
            int aWTime = X81MDataDecoder.getAWTime(buf);
            Date realDate = X81MDataDecoder.getRealTime(buf);
            X81MDataDecoder.getAndSetST(buf, mData);
            X81MDataDecoder.setSuccessfulMData(mData, hc, DIODI1, SER, dPower, cHeat, tPower, flow, cAflow, sWTemperature, rWTemperature, aWTime, realDate);
        } else {
            this.log.error("MData Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
    }
}

