/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.BaseMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X81Meter80Decoder
extends BaseMDataDecoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void decode(ByteBuf buf, MBusCommand hc) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 15) {
            String DIODI1;
            MData mData = new MData();
            ByteBuf byteBuf = null;
            try {
                byteBuf = buf.readBytes(2);
                DIODI1 = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            }
            finally {
                ReferenceCountUtil.release((Object)byteBuf);
            }
            byte SER = buf.readByte();
            int count = X81Meter80Decoder.getCount(buf);
            double temperature = X81Meter80Decoder.getTemperature(buf);
            double roomTemperature = X81Meter80Decoder.getTemperature(buf);
            buf.skipBytes(2);
            byte version = buf.readByte();
            X81Meter80Decoder.getAndSet80ST(buf, mData);
            X81Meter80Decoder.setSuccessful80MData(mData, hc, DIODI1, SER, count, temperature, roomTemperature, version);
        } else {
            this.log.error("MData Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
    }
}

