/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.BaseMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X81Meter80ReadDecoder
extends BaseMDataDecoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void decode(ByteBuf buf, MBusCommand hc) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 46) {
            String DIODI1;
            MData mData = new MData();
            ByteBuf byteBuf = null;
            try {
                byteBuf = buf.readBytes(2);
                DIODI1 = ByteBufUtil.hexDump((ByteBuf)byteBuf);
            }
            finally {
                ReferenceCountUtil.release((Object)byteBuf);
            }
            byte SER = buf.readByte();
            double cColdEnergy = X81Meter80ReadDecoder.getCColdEnergy(buf);
            double cHeat = X81Meter80ReadDecoder.getCHeat(buf);
            double tPower = X81Meter80ReadDecoder.getTPower(buf);
            double flow = X81Meter80ReadDecoder.getFlow(buf);
            double cAflow = X81Meter80ReadDecoder.getCAFlow(buf);
            double sWTemperature = X81Meter80ReadDecoder.getSWTemperature(buf);
            double rWTemperature = X81Meter80ReadDecoder.getRWTemperature(buf);
            int aWTime = X81Meter80ReadDecoder.getAWTime(buf);
            Date realDate = X81Meter80ReadDecoder.getRealTime(buf);
            X81Meter80ReadDecoder.getAndSet80ST(buf, mData);
            X81Meter80ReadDecoder.setSuccessfulMData(mData, hc, DIODI1, SER, cColdEnergy, cHeat, tPower, flow, cAflow, sWTemperature, rWTemperature, aWTime, realDate);
        } else {
            this.log.error("MData Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
    }
}

