/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.BaseMDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X84Meter80Decoder
extends BaseMDataDecoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    void decode(ByteBuf buf, MBusCommand hc) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 6) {
            MData mData = new MData();
            String DIODI1 = ByteBufUtil.hexDump((ByteBuf)buf.readBytes(2));
            byte SER = buf.readByte();
            String code = HexDump.toHex((byte)buf.readByte());
            mData.setoPCode(code);
            X84Meter80Decoder.getAndSetWriteST(buf, mData);
            X84Meter80Decoder.setSuccessful84MData(mData, hc, DIODI1, SER);
        } else {
            this.log.error("MData Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump((ByteBuf)buf));
        }
    }
}

