/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.codec.encoder;

import com.easesource.iot.protoparser.cjt188.v2004.codec.encoder.BaseMdataEncoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDataEncoder {
    private static final Map<String, BaseMdataEncoder> encoderMap = new ConcurrentHashMap<String, BaseMdataEncoder>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public synchronized BaseMdataEncoder getRequestEncoder(String type) {
        if (!encoderMap.containsKey(type)) {
            String className = this.getClass().getPackage().getName() + ".X" + type + "MDataEncoder";
            try {
                Class<?> clazz = Class.forName(className);
                BaseMdataEncoder encoder = (BaseMdataEncoder)clazz.newInstance();
                encoderMap.put(type, encoder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return encoderMap.get(type);
    }

    public byte[] encode(String type, MData data) {
        BaseMdataEncoder encoder = this.getRequestEncoder(type);
        return encoder.assemblyMBus(data);
    }
}

