/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.read;

import com.easesource.iot.protoparser.base.utils.Check;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.cjt188.v2004.codec.decoder.MDataDecoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.model.MBusConstants;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBusReader {
    private static final Logger log = LoggerFactory.getLogger(MBusReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBus decode(ByteBuf in) {
        MBus mBus;
        block11: {
            mBus = new MBus();
            try {
                if (in.readableBytes() > MBusConstants.LEADBYTE_LEN) {
                    in.skipBytes(MBusConstants.LEADBYTE_LEN);
                    byte realLeadByte = in.readByte();
                    if (realLeadByte == 104) {
                        mBus.settCode(HexDump.toHex((byte)in.readByte()));
                        ByteBuf adress = null;
                        try {
                            adress = in.readBytes(7);
                            String ad = "";
                            for (int i = 6; i >= 0; --i) {
                                ad = ad + HexDump.toHex((byte)adress.readerIndex(i).readByte());
                            }
                            mBus.setSite(ad);
                        }
                        finally {
                            ReferenceCountUtil.release((Object)adress);
                        }
                        mBus.setCol(HexDump.toHex((byte)in.readByte()));
                        byte length = in.readByte();
                        mBus.setLength(length);
                        byte[] mData = new byte[length];
                        int dataLength = in.readableBytes() - 2;
                        in.readBytes(mData);
                        if (dataLength != length || !Check.checkBytesCol((byte[])mData, (String)mBus.getCol())) {
                            log.error("\u6570\u636e\u683c\u5f0f\u5f02\u5e38>>>>>>>");
                            return null;
                        }
                        mBus.setMdata(mData);
                        MBusCommand cmd = new MBusCommand(mBus.getCol(), mBus.getSite());
                        MDataDecoder mDataDecoder = new MDataDecoder();
                        mDataDecoder.decode(mBus, cmd);
                        mBus.setmData(cmd.getmData());
                        mBus.setCheckCode(HexDump.toHex((byte)in.readByte()));
                        if (in.readByte() == 22) {
                            log.info("mBus\u89e3\u6790\u6210\u529f >>>>>>>");
                        }
                        break block11;
                    }
                    log.error("mBus\u89e3\u6790\u5931\u8d25>>>>>>>\u683c\u5f0f\u4e0d\u6b63\u786e");
                    break block11;
                }
                log.error("mBus\u89e3\u6790\u5931\u8d25>>>>>>>\u524d\u5bfc\u5b57\u8282FE\u4e2a\u6570\u4e0d\u8db3");
            }
            catch (Exception e) {
                log.error(e.getMessage(), e.fillInStackTrace());
            }
        }
        return mBus;
    }
}

