/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.cjt188.v2004.write;

import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.cjt188.v2004.codec.encoder.MDataEncoder;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBusCommand;
import com.easesource.iot.protoparser.cjt188.v2004.model.MBusConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBusWriter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public byte[] encode(MBus bus) {
        byte[] lead = MBusConstants.LEADBYTE;
        byte[] head = new byte[]{104};
        byte[] tCode = BytesUtil.stringToByte((String)bus.gettCode());
        byte[] site = BytesUtil.byteToByte((byte[])BytesUtil.stringToByte((String)bus.getSite()));
        byte[] col = BytesUtil.stringToByte((String)bus.getCol());
        byte length = 0;
        if (bus.getCol().equals("04")) {
            length = 4;
        } else if (bus.getCol().equals("01")) {
            length = 3;
        }
        byte[] bef = BytesUtil.byte4Merger((byte[])head, (byte[])tCode, (byte[])site, (byte[])col);
        byte[] before = BytesUtil.bytesAndbyte((byte[])bef, (byte)length);
        byte[] mBus_lead = BytesUtil.byteMerger((byte[])lead, (byte[])before);
        MBusCommand cmd = new MBusCommand(bus.getCol(), bus.getSite());
        bus.setmBusCommand(cmd);
        String function = bus.getmBusCommand().getFunction();
        MDataEncoder encoder = new MDataEncoder();
        byte[] mBusData = encoder.encode(function, bus.getmData());
        byte[] checkCode = BytesUtil.stringToByte((String)BytesUtil.getCheckCode((byte[])BytesUtil.byteMerger((byte[])before, (byte[])mBusData)));
        byte end = 22;
        byte[] mBus_end = BytesUtil.bytesAndbyte((byte[])checkCode, (byte)end);
        byte[] mData = BytesUtil.byte3Merger((byte[])mBus_lead, (byte[])mBusData, (byte[])mBus_end);
        return mData;
    }
}

