package com.easesource.iot.protoparser.gaeadcu.constant;

import java.nio.ByteOrder;

public class Constants {
    public static final String DCU_PROTOCOL = "GAEA_V4";
    public static final String DCU_PROTOCOL_TAG = "GAEA_DCU_V4";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.S";
    public static final String PK_DELIMITED = "|";
    // 字节顺序，低字节在低地址，高字节在高地址
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    // 通讯标识
    public static final byte[] SIGNATURE = "GAEA".getBytes();
    public static final int HEAD_LEN = 12;
    public static final int SIGNATURE_LEN = SIGNATURE.length;
    //透明转发 端口，波特率，校验，停止位总字节
    public static final int PARAM_LEN = 4;
    public static final int F9DATA_LEN = 26;
    public static final byte F9_BYTE = (byte)0xf9;
    public static final int X02DATA_LEN = 9;
    public static final int X03DATA_LEN = 13;
    public static final int F9MBUS_LEN = 20;
    public static final int X04DATA_LEN = 16;
    public static final int X05DATA_LEN = 16;
    public static final int X07DATA_LEN = 2;
    public static final int X08DATA_LEN = 8;
    public static final int X09DATA_LEN = 9;
    public static final int X10DATA_LEN = 10;
    public static final int X20DATA_LEN = 20;
    public static final int X21DATA_LEN = 9;
    public static final int X88DATA_LEN = 88;
    public static final int XF8DATA_LEN = 8;
    public static final int XFADATA_LEN = 74;
    public static final int XFBDATA_LEN = 14;
    public static final byte FUNCTION_CODE_HEART = 0x01;// 数据采集器心跳
    public static final byte FUNCTION_CODE_HEART_CONFIRM = (byte) 0x85;// 数据采集器心跳确认
    public static final byte FUNCTION_CODE_DATAUP_CONFIRM = (byte) 0x80;// 数据采集器数据报文确认

    public static final int FUNCTION_CODE_DATAUP = 0x00;// 数据采集器数据报文
    public static final int FUNCTION_CODE_DATAUP_DES = 0x10;// 数据采集器数据报文(DES加密)
    public static final int FUNCTION_CODE_DATAUP_AES = 0x20;// 数据采集器数据报文(AES128加密)

    public static final byte FUNCTION_CODE_DATADOWN = (byte) 0x80;// 下发DCU报文
    public static final byte FUNCTION_CODE_DATADOWN_DES = (byte) 0x90;// 下发DCU报文(DES加密)
    public static final byte FUNCTION_CODE_DATADOWN_AES = (byte) 0xA0;// 下发DCU报文(AES128加密)

    public static final byte ASDU_TYPE_CONFIRM = (byte) 0x88;
    public static final byte ASDU_COT_CONFIRM = 0x07;

    public static final byte ASDU_COT_REPLY = 0x05;

    public static final byte TYPE_CHECKTIME = 0x02;// 对时命令
    public static final byte TYPE_GETMETERINFO = 0x08;// 获取表计信息
    public static final byte TYPE_GETDCUVERSION = 0x09;// 获取DCU版本信息
    public static final byte TYPE_GETTIME = 0x10;// 获取时钟命令
    public static final byte TYPE_DATA_WITHOUT_TIME = 0x11;
    public static final byte TYPE_DATA_WITH_TIME = 0x12;
    public static final byte TYPE_STATE_WITHOUT_TIME = 0x13;
    public static final byte TYPE_STATE_WITH_TIME = 0x14;
    public static final byte TYPE_CHECK_BY_WEB = (byte) 0x80;// 表计对点命令 主站发起
    public static final byte TYPE_CHECK_BY_DCU = (byte) 0x81;// 表计对点信息 表计发起
    public static final byte TYPE_SET_SECRETKEY = (byte) 0x82;// DCU通讯密码设置
    public static final byte TYPE_SET_YK_COMMAND = 0x03;// 遥控命令
    public static final byte TYPE_SET_YT_FLOAT_COMMAND = 0x04;// 遥调命令（浮点）
    public static final byte TYPE_SET_YT_INT_COMMAND = 0x05;// 遥调命令(整型)
    public static final byte TYPE_SET_YT_STRING_COMMAND = 0x06;// 遥调命令(字符串)
    public static final byte TYPE_VERSION_UPDATE = 0x07;// DCU版本升级
    public static final byte TYPE_GETALLGROUP = 0x20;// 获取所有组
    public static final byte TYPE_GETSELECTEDGROUP = 0x21;// 获取指定组
    //冻结任务相关
    public static final byte TYPE_SET_FROZENTASK = 0x22;//冻结任务下发
    public static final byte TYPE_GET_FROZENTASK = 0x23;//冻结任务配置读取
    public static final byte TYPE_UP_FROZENDATA = 0x24;//冻结任务上送
    public static final byte TYPE_CALL_FROZENDATA = 0x25;//冻结任务配置读取

    public static final byte TYPE_FORWARD_COMMAND = (byte) 0xF9;// 透明转发命令

    public static final byte TYPE_EMT621_UPDATE = (byte) 0xFA;// EMT621在线升级命令
    public static final byte TYPE_UPDATEFILE_DWONLOAD = (byte) 0xFB;// EMT621升级文件下载

    public static final byte TYPE_SET_TASK_STATE_COMMAND = 0x26;// 设置表计任务状态
    public static final byte TYPE_GET_TASK_STATE_COMMAND = 0x27;// 获取表计任务状态
    public static final byte TYPE_GETPARAM = (byte) 0x83;
    public static final byte TYPE_READPARAM = (byte) 0x84;
    public static final byte TYPE_GET_INT_PARAM = (byte) 0x85;
    public static final byte TYPE_SETPARAM = (byte) 0x86;
    public static final byte TYPE_REVERSEPROXY = (byte) 0xF8;
    // 对时命令
    public static final String STYPE_CHECKTIME = "02";//
    // 获取表计信息
    public static final String STYPE_GETMETERINFO = "08";//
    // 获取DCU版本信息
    public static final String STYPE_GETDCUVERSION = "09";//
    // 获取时钟命令
    public static final String STYPE_GETTIME = "10";//
    public static final String STYPE_DATA_WITHOUT_TIME = "11";//
    public static final String STYPE_DATA_WITH_TIME = "12";//
    public static final String STYPE_STATE_WITHOUT_TIME = "13";//
    public static final String STYPE_STATE_WITH_TIME = "14";//
    // 表计对点命令 主站发起
    public static final String STYPE_CHECK_BY_WEB = "80";//
    // 表计对点信息 表计发起
    public static final String STYPE_CHECK_BY_DCU = "81";//
    // DCU通讯密码设置
    public static final String STYPE_SET_SECRETKEY = "82";
    // 遥控命令
    public static final String STYPE_SET_YK_COMMAND = "03";
    // 遥调命令
    public static final String STYPE_SET_YT_FLOAT_COMMAND = "04";
    public static final String STYPE_SET_YT_INT_COMMAND = "05";
    public static final String STYPE_SET_YT_STRING_COMMAND = "06";
    //DCU升级
    public static final String STYPE_VERSION_UPDATE = "07";
    //获取所有组
    public static final String STYPE_GETALLGROUP = "20";
    public static final String STYPE_GETSELECTEDGROUP = "21";
    //冻结任务相关
    public static final String STYPE_SET_FROZENTASK = "22";//冻结任务下发
    public static final String STYPE_GET_FROZENTASK = "23";//冻结任务配置读取
    public static final String STYPE_UP_FROZENDATA = "24";//冻结任务上送
    public static final String STYPE_CALL_FROZENDATA = "25";//冻结任务配置读取

    public static final String STYPE_SETTASKSTATE = "26";// 设置表计任务状态
    public static final String STYPE_GETTASKSTATE = "27";// 获取表计任务状态

    public static final String STYPE_GETPARAM = "83";
    public static final String STYPE_GET_INT_PARAM = "85";
    public static final String STYPE_SETPARAM = "86";

    public static final String STYPE_FORWARD_COMMAND = "F9";// 透明转发命令

    public static final String STYPE_EMT621_UPDATE = "FA";// EMT621在线升级命令
    public static final String STYPE_UPDATEFILE_DWONLOAD = "FB";// EMT621升级文件下载
    /**
     * 参数设置结果：设置成功
     */
    public static final int ITEM_STATUS_SUCCESS = 0;
    /**
     * 参数设置结果：不确定
     */
    public static final int ITEM_STATUS_AMBIGUOUS = 1;
    /**
     * 参数设置结果：设置失败
     */
    public static final int ITEM_STATUS_FAILED = 2;

    /**
     * 主站操作命令状态: 进行中
     */
    public static final String STATUS_RUNNING = "0";
    /**
     * 主站操作命令状态: 已结束
     */
    public static final String STATUS_SUCCESS = "1";
    /**
     * 主站操作命令状态: 终端执行失败
     */
    public static final String STATUS_RTU_FAILED = "2";
    /**
     * 主站操作命令状态: 通道错误
     */
    public static final String STATUS_COMM_FAILED = "3";
    /**
     * 主站操作命令状态: 终端超时无应答
     */
    public static final String STATUS_TIMEOUT = "4";
    /**
     * 主站操作命令状态: 中继命令无应答
     */
    public static final String STATUS_FWD_CMD_NO_RESPONSE = "5";
    /**
     * 主站操作命令状态: 设置内容非法
     */
    public static final String STATUS_PARA_INVALID = "6";
    /**
     * 主站操作命令状态: 权限不足
     */
    public static final String STATUS_PERMISSION_DENIDE = "7";
    /**
     * 主站操作命令状态: 无此数据项
     */
    public static final String STATUS_ITEM_INVALID = "8";
    /**
     * 主站操作命令状态: 命令时间失效
     */
    public static final String STATUS_TIME_OVER = "9";
    /**
     * 主站操作命令状态: 目标地址不存在
     */
    public static final String STATUS_TARGET_UNREACHABLE = "10";
    /**
     * 主站操作命令状态: 发送失败
     */
    public static final String STATUS_SEND_FAILURE = "11";
    /**
     * 主站操作命令状态: 短信帧太长
     */
    public static final String STATUS_SMS_OVERFLOW = "12";
    /**
     * 主站操作命令状态: 主站传入参数错误，组帧失败
     */
    public static final String STATUS_PRAR_ERROR = "13";
    /**
     * 主站操作命令状态: 前置机解析失败
     */
    public static final String STATUS_PARSE_ERROR = "14";
    /**
     * 主站操作命令状态: 结果保存入库失败
     */
    public static final String STATUS_TODB_ERROR = "15";
    /**
     * 主站操作命令状态: 终端与表计无通讯
     */
    public static final String STATUS_RTUAMTCOM_ERROR = "16";
    // DCU未加密
    public static final String DCU_UNENCRYPT = "17";
    // DCU加密(主站未设置加密)
    public static final String DCU_ENCRYPT_ERROR = "18";
    // DCU加密方式错误
    public static final String DCU_ENCRYPTTYPE_ERROR = "19";
    // DCU解密出错
    public static final String DCU_DECRYPT_ERROR = "20";

    public static final double MAX_LJL_VAL = 1.00E12d;

    public static final byte COT_SURE = 0x07;
    public static final byte COT_DENY = 0x47;

    public static final byte COT_TF = 0x03;
    public static final byte COT_BG = 0x02;
    public static final byte COT_ASK = 0x05;
    public static final byte COT_REPLY = 0x05;
    public static final byte COT_ACTIVE = 0x06;

    public static final int SECRET_TYPE_NONE = 0;
    public static final int SECRET_TYPE_DES = 1;
    public static final int SECRET_TYPE_AES = 2;
}
