package com.easesource.iot.protoparser.gaeadcu.handler;


import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.task.WriterToUpFile;
import com.easesource.iot.protoparser.gaeadcu.util.WriterUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

@Component
@ChannelHandler.Sharable
public class DCUMessageEncoder extends MessageToByteEncoder<DcuMessage> {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    public WriterToUpFile writerToUpFile;


    @Override
    protected void encode(ChannelHandlerContext ctx, DcuMessage msg, ByteBuf out) throws Exception {
        int length = 0;
        if(msg.getData() != null){
             length = HEAD_LEN + msg.getData().length;
        }else {
            length = HEAD_LEN;
        }
        //新创建出来一个byteBuf,所以不会导致计数器为0
        //在此使用堆外缓冲区是为了将数据更快速的写入内核中，如果使用堆缓冲区多一次
        //堆内存向内核进行内存拷贝，这样会降低性能。
        ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(length);
        try {
            byteBuf.writeBytes(SIGNATURE);
            byteBuf.order(BYTE_ORDER).writeShort(length);
            byteBuf.writeByte(msg.getFunction());
            byteBuf.writeByte(msg.getSeq());
            int rtuId = msg.getRtuId();
            byteBuf.order(BYTE_ORDER).writeInt(rtuId);
            if (msg.getData() != null && msg.getData().length > 0) {
                byteBuf.writeBytes(msg.getData());
            }
            Channel cnl = ctx.channel();
            ByteBuf buf = null;
            byte[] data;
            try {
                buf = byteBuf.copy();
                int len = buf.readableBytes();
                data = new byte[len];
                buf.readBytes(data);
                if(log.isDebugEnabled()){
                    log.debug("Encoder>>>>>>>" + HexDump.hexDump(data));
                }
            }finally {
                ReferenceCountUtil.release(buf);
            }
            Boolean flag = msg.getTransDown();
            writerToUpFile.handle(WriterUtil.writeToFile(flag,rtuId,data));

            if (cnl.isWritable()) {
                cnl.writeAndFlush(byteBuf);
            }
        }finally {
            //必须释放自己申请的内存池缓冲区，否则会内存泄漏
            //out是netty自身socket发送的ByteBuf系统会自动释放，用户不需要做二次释放
                ReferenceCountUtil.release(byteBuf);
                ReferenceCountUtil.release(msg);
        }
    }


}
