package com.easesource.iot.protoparser.gaeadcu.handler;


import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;


public class DCUMessageRecognizer extends ByteToMessageDecoder {
    private final Logger logger= LoggerFactory.getLogger(getClass());

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> list) throws Exception {
        boolean valid;
        int curIndex;
        byte[] prefixBytes = new byte[SIGNATURE_LEN];
        while(in.readableBytes() >= HEAD_LEN) {
            if (logger.isDebugEnabled()) {
                logger.debug(">>>>>> 可读最大报文字节数" + in.readableBytes());
            }
            //报文是否有效标识
            valid = false;
            curIndex = in.readerIndex();
            //遍历报文，查询通讯标识,判断报文是否有效
            for (int pos = 0; pos < in.readableBytes(); pos ++) {
                //设置读未知
                in.readerIndex(curIndex + pos);
                in.getBytes(curIndex + pos, prefixBytes, 0, SIGNATURE_LEN);
                if (Arrays.equals(prefixBytes, SIGNATURE)) {
                    valid = true;
                    break;
                }
            }
            if (valid) {
                //报文有效，加入到下个处理器
                //报文长度
                short length = (short) in.order(BYTE_ORDER).getUnsignedShort(in.readerIndex() + SIGNATURE_LEN);
                if (in.readableBytes() >= length) {
                    list.add(in.readBytes(length));
                } else {
                    break;
                }
                ctx.flush();
            }
        }
        }
}
