package com.easesource.iot.protoparser.gaeadcu.handler;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.protoparser.base.cache.ChannelIpPortCache;
import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder.DataItemDecoder;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.task.WriterToUpFile;
import com.easesource.iot.protoparser.gaeadcu.util.WriterUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.*;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import java.net.InetSocketAddress;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;


@Component
@Qualifier("DCUSocketReadHandler")
@ChannelHandler.Sharable
public class DCUReadHandler extends SimpleChannelInboundHandler<ByteBuf> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    public  ChannelGroup channels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);

    @Autowired
    private DataItemDecoder dataItemDecoder;

    @Autowired
    public WriterToUpFile writerToUpFile;

    private DataCommand cmd;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            Channel incoming = ctx.channel();
                ByteBuf buf = null;
                byte[] arr;
                try {
                    buf = in.copy();
                    int len = buf.readableBytes();
                    arr = new byte[len];
                    buf.readBytes(arr);
                } finally {
                    ReferenceCountUtil.release(buf);
                }
            DcuMessage message = new DcuMessage();
            in.skipBytes(SIGNATURE_LEN);
            int length = in.order(BYTE_ORDER).readUnsignedShort();
            message.setLength(length);
            byte function = in.readByte();
            message.setFunction(function);
            message.setSeq(in.order(BYTE_ORDER).readUnsignedByte());
            int rtuId = in.order(BYTE_ORDER).readInt();
            message.setRtuId(rtuId);
            if( logger.isDebugEnabled()){
                logger.debug("Decoder>>>>>>>"+ "Channel:"+incoming.id().toString()+" 逻辑地址:"+HexDump.toHex(rtuId));
            }
            Boolean flag = message.getTransDown();
            //开启多线程保存报文
            if(logger.isInfoEnabled()) {
                if(StringUtils.equals(HexDump.toHex(rtuId), "700205E8")) {
                    logger.info("逻辑地址: " + HexDump.toHex(rtuId) + "，保存报文。");
                }
            }
            writerToUpFile.handle(WriterUtil.writeToFile(flag,rtuId,arr));
            // 保存数据采集器的终端地址，并和channel通道进行绑定
            DcuIdChannelCache.putCache(Integer.valueOf(message.getRtuId()), incoming);

            byte[] data = new byte[length - HEAD_LEN];
            //判断是否有data数据，如果有，就进行读取，和解析ASDU部分。如果没有不用解析，不用设置(都为空)
            if(in.isReadable()) {
                in.readBytes(data);
                message.setData(data);
                /*if(logger.isInfoEnabled()) {
                    if(StringUtils.equals(HexDump.toHex(rtuId), "700205E8")) {
                        logger.info("逻辑地址：" + HexDump.toHex(rtuId));
                        logger.info(message.toString() + "加密类型" + message.getEncryptType() + "桢类型" + message.getFrameType() + "传输方向" + message.getTransDown());
                    }
                }*/
                // 解析ASDU
                cmd = new DataCommand(message.getFunction(), (short) message.getSeq(), message.getRtuId());
                Boolean isDecoder = dataItemDecoder.decode(message, cmd);
                if (!isDecoder) {
                    logger.error("逻辑地址：" + HexDump.toHex(rtuId) + "，DCU DataItem >>>>>>>> 解析失败");
                    return;
                }
                List<DataItem> items = cmd.getItems();
                message.setDataItemList(items);
            }
            //发送确认或者心跳。
            DcuMessage confirmMessage = message.createConfirmMessage();
            /*if(logger.isInfoEnabled()) {
                if(StringUtils.equals(HexDump.toHex(rtuId), "700205E8")) {
                    logger.info("逻辑地址：" + HexDump.toHex(rtuId));
                    logger.info("DcuMessage : " + JsonConvertUtils.convertToString(confirmMessage));
                }
            }*/
            if (message.createConfirmMessage() != null) {
                Channel cnl = DcuIdChannelCache.getKeyCache(Integer.valueOf(message.getRtuId()));
                if (logger.isDebugEnabled()) {
                    logger.debug("计数器" + in.refCnt());
                }
                if (cnl != null && cnl.isWritable()) {
                    cnl.writeAndFlush(confirmMessage);
                    logger.debug("心跳确认>>>>>>>" + cnl.id().toString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("计数器" + in.refCnt());
                }
            }
            //传递到pipeline中的下一个 handler
            ctx.fireChannelRead(message);
            ctx.flush();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        channels.add(incoming);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        channels.remove(incoming);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress) incoming.remoteAddress();
        String ip = insocket.getAddress().getHostAddress();
        int port = insocket.getPort();
        String ipAndPort = ip +":"+ port;
        //logger.info("在线 =======>连接 Channel:"+incoming.id().toString()+ipAndPort);
        ChannelIpPortCache.putCache(incoming,ipAndPort);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress) incoming.remoteAddress();
        String ip = insocket.getAddress().getHostAddress();
        int port = insocket.getPort();
        String ipAndPort = ip +":" + port;
        //logger.info("断开 =======>连接 Channel:"+incoming.id().toString()+ipAndPort);
        ChannelIpPortCache.removeCache(incoming);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause)
            throws Exception {
        Channel incoming = ctx.channel();
        //logger.info("异常 =======>连接 Channel:"+incoming.id().toString());
        cause.printStackTrace();
        ctx.close();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}
