package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;


import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.IMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


@Component
public class DataItemDecoder implements IDataItemDecoder {
    private final Map<Byte, BaseDataItemDecoder> decoderMap = new ConcurrentHashMap<Byte, BaseDataItemDecoder>();
    private final Logger log = LoggerFactory.getLogger(getClass());

    public synchronized BaseDataItemDecoder getDataItemDecoder(byte type) {
        if (!decoderMap.containsKey(type)) {
            String className = getClass().getPackage().getName() + ".X" + HexDump.toHex(type) + "DataItemDecoder";
            try {
                Class clazz = Class.forName(className);
                BaseDataItemDecoder decoder = (BaseDataItemDecoder) clazz.newInstance();
                decoderMap.put(type, decoder);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return decoderMap.get(type);
    }

    @Override
    public boolean decode(IMessage message, DataCommand command) throws Exception{
        DcuMessage msg = (DcuMessage) message;
        byte[] data = msg.getData();
        if(data.length == 0){
            return false;
        }
        ByteBuf buf = null;
        try{
            buf = ByteBufAllocator.DEFAULT.directBuffer(data.length);
            buf.writeBytes(data);
            // 类型标识
            byte type = buf.readByte();
            command.setType(type);
            // 传送原因
            byte cot = buf.readByte();
            command.setCot(cot);
            BaseDataItemDecoder decoder = getDataItemDecoder(command.getType());
            if (decoder == null) {
                log.warn("type:{} decode not exists", HexDump.toHex(command.getType()));
                return false;
            }

            if(buf != null && buf.isReadable()){
                decoder.decode(buf, command);
                //规避解析mbus异常的情况
                if(command.getStatus() == null){
                    return false;
                }
            }
        }finally {
            ReferenceCountUtil.release(buf);
        }
        return true;
    }
}
