package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class X02DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        ByteBuf timeBuf = null ;
        if (readableBytes == 7) {
            try {
                timeBuf = buf.readBytes(7);
                String sTime = parseDataTimeStr(timeBuf);
                setSuccessDataItem(command, sTime);
            }finally {
                ReferenceCountUtil.release(timeBuf);
            }
        } else {
            log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
        }
    }

}
