package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.BYTE_ORDER;

class X04DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        ByteBuf channelBuf = null;
        ByteBuf tnBuf = null;
        if (readableBytes > 12) {
            try {
                channelBuf = buf.readBytes(6);
                String channel = toLittleEndianHex(channelBuf).toUpperCase();
                tnBuf = buf.readBytes(4);
                String tn = toLittleEndianHex(tnBuf).toUpperCase();
                setSuccessDataItem(command, getValue(buf), tn, channel);
            }finally {
                ReferenceCountUtil.release(channelBuf);
                ReferenceCountUtil.release(tnBuf);
            }
        } else {
            log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
        }
    }

    public String getValue(ByteBuf buf) {
        float value = buf.order(BYTE_ORDER).readFloat();
        return Float.toString(value);
    }

}
