package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_REPLY;


class X08DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        ByteBuf sValueBuf = null;
        ByteBuf valueBuf = null;
        if (command.getCot() == ASDU_COT_REPLY) {
            if (readableBytes == 86) {
                try {
                    sValueBuf = buf.readBytes(6);
                    String sValue = toLittleEndianHex(sValueBuf).toUpperCase();
                    for (int j = 0; j < 5; j++) {
                        valueBuf = buf.readBytes(16);
                        sValue += "#" + toAsciiString(valueBuf);
                    }
                    // 通信地址6字节+表计型号16字节+生产日期16字节+协议版本号16字节+软件版本号16字节+硬件版本号16字节
                    setSuccessDataItem(command, sValue);
                }finally {
                    ReferenceCountUtil.release(sValueBuf);
                    ReferenceCountUtil.release(valueBuf);
                }
            } else {
                log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
            }
        } else {
            log.warn("Cot[" + HexDump.toHex(command.getCot()) + "] return,no more Content.");
            setFailedDataItem(command);
        }
    }

}
