package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_REPLY;


class X09DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        ByteBuf valueBuf = null;
        if (command.getCot() == ASDU_COT_REPLY) {
            if (readableBytes == 16) {
                try {
                    valueBuf = buf.readBytes(16);
                    String value = toAsciiString(valueBuf);
                    setSuccessDataItem(command, value);
                }finally {
                    ReferenceCountUtil.release(valueBuf);
                }
            } else {
                log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
            }
        } else {
            log.warn("Cot[" + HexDump.toHex(command.getCot()) + "] return,no more Content.");
            setFailedDataItem(command);
        }
    }

}
