package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.STATUS_SUCCESS;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.STYPE_DATA_WITH_TIME;


class X12DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int iMeterCount = buf.readUnsignedByte();
        ByteBuf byteBuf = null;
        // 12 03 00 报文未进行相应处理
        for (int i = 0; i < iMeterCount; i++) {
            try {
                byteBuf = buf.readBytes(6);
                String sMeterAddr = toLittleEndianHex(byteBuf).toUpperCase();
                // 开入点数
                int iYXCount = buf.readUnsignedByte();
                // 模入点数
                int iYCCount = buf.readUnsignedByte();
                // 电度数据
                int iLJCount = buf.readUnsignedByte();
                int readableBytes = buf.readableBytes();
                if (readableBytes < (iYXCount * 12 + iYCCount * 15 + iLJCount * 19)) {
                    log.error("DataArea Length is not Enough,DCU:{},Data:{}", command.getRtuId(), ByteBufUtil.hexDump(buf));
                    continue;
                }
                if (iYXCount > 0) {
                    explainDIItem(buf, iYXCount, true, command, sMeterAddr, null, STYPE_DATA_WITH_TIME);
                }
                if (iYCCount > 0) {
                    explainAIItem(buf, iYCCount, true, command, sMeterAddr, null, STYPE_DATA_WITH_TIME);
                }
                if (iLJCount > 0) {
                    explainPIItem(buf, iLJCount, true, command, sMeterAddr, null, STYPE_DATA_WITH_TIME);
                }
                command.setStatus(STATUS_SUCCESS);
            }finally {
                ReferenceCountUtil.release(byteBuf);
            }
        }
    }

}
