package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;


import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Date;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.STATUS_SUCCESS;


class X13DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int iMeterCount = buf.readUnsignedByte();
        Date now = new Date(System.currentTimeMillis());
        ByteBuf byteBuf = null;
        for (int i = 0; i < iMeterCount; i++) {
            try {
                byteBuf = buf.readBytes(6);
                String sMeterAddr = toLittleEndianHex(byteBuf).toUpperCase();
                short value = buf.readUnsignedByte();
                setSuccessDataItem(command, value == 1 ? "0" : "1", null, sMeterAddr, now);
            }finally {
                ReferenceCountUtil.release(byteBuf);
            }
        }
        command.setStatus(STATUS_SUCCESS);
    }

}
