package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.UnsupportedEncodingException;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_REPLY;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.BYTE_ORDER;


class X20DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        if (command.getCot() == ASDU_COT_REPLY) {
            if (readableBytes > 10) {
                buf.readBytes(6);
                int length = buf.order(BYTE_ORDER).readInt();
                String value = "";
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                try {
                    value = new String(bytes, "UTF-8");
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                setSuccessDataItem(command, value);
            } else {
                log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
            }
        } else {
            log.warn("Cot[" + HexDump.toHex(command.getCot()) + "] return,no more Content.");
            setFailedDataItem(command);
        }
    }

}
