package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ITEM_STATUS_SUCCESS;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.STATUS_SUCCESS;


class X23DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int taskCount = buf.readUnsignedByte();
        Date now = new Date(System.currentTimeMillis());
        DataItem groupItem = explainGroupItem(taskCount, command);
        Map<String, Object> attrs;
        List<String> points;
        DataItem dataItem;
        ByteBuf addBuf = null;
        ByteBuf byteBuf = null;
        for (int i = 0; i < taskCount; i++) {
           try {
               addBuf = buf.readBytes(6);
               String meterAddr = toLittleEndianHex(addBuf).toUpperCase();
               short taskNo = buf.readUnsignedByte();
               byte frozenParam = buf.readByte();
               byte sendParam = buf.readByte();
               short pointCount = buf.readUnsignedByte();
               attrs = new HashMap<String, Object>();
               attrs.put("FrozenParam", frozenParam);
               attrs.put("SendParam", sendParam);
               if (pointCount > 0) {
                   points = new ArrayList<String>(pointCount);
                   for (int j = 0; j < pointCount; j++) {
                       byteBuf = buf.readBytes(4);
                       points.add(toLittleEndianHex(byteBuf).toUpperCase());
                   }
                   attrs.put("SendPoints", points);
               }
               dataItem = setSuccessDataItem(groupItem.getItemCommand(), Short.toString(pointCount), String.valueOf(taskNo), meterAddr, now);
               dataItem.setAttributes(attrs);
           }finally {
               ReferenceCountUtil.release(addBuf);
               ReferenceCountUtil.release(byteBuf);
           }
        }
        command.setRequestTime(now);
        command.setStatus(STATUS_SUCCESS);
    }

    protected DataItem explainGroupItem(int taskCount, DataCommand command) {
        DataItem result = new DataItem();
        result.setCot(command.getCot());
        result.setCode(HexDump.toHex(command.getType()));
        result.setTn(String.valueOf(taskCount));
        result.setValue("success");
        result.setTime(new Date());
        result.setItemCommand(new DataCommand(command.getFunction(), command.getSeq(), command.getRtuId()));
        result.setStatus(ITEM_STATUS_SUCCESS);
        command.addItem(result);
        return result;
    }

}
