package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;


import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.nio.ByteOrder;
import java.util.Date;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;


class X24DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private static final boolean NOT_WITH_TIME = false;

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        if (command.getCot() == ASDU_COT_REPLY) {
            decodeCallback(buf, command);
            return;
        }
        int taskCount = buf.readUnsignedByte();
        ByteBuf addBuf = null;
        ByteBuf dateBuf = null;
        for (int i = 0; i < taskCount; i++) {
            try {
                addBuf = buf.readBytes(6);
                String meterAddr = toLittleEndianHex(addBuf).toUpperCase();
                int itemCount = buf.order(ByteOrder.LITTLE_ENDIAN).readUnsignedShort();
                for (int j = 0; j < itemCount; j++) {
                    dateBuf = buf.readBytes(7);
                    Date date = parseDataTime(dateBuf);
                    // 开入点数
                    int iYXCount = buf.readUnsignedByte();
                    // 模入点数
                    int iYCCount = buf.readUnsignedByte();
                    // 电度数据
                    int iLJCount = buf.readUnsignedByte();
                    int readableBytes = buf.readableBytes();
                    if (readableBytes < (iYXCount * 5 + iYCCount * 8 + iLJCount * 12)) {
                        log.error("DataArea Length is not Enough,DCU:{},Data:{}", command.getRtuId(), ByteBufUtil.hexDump(buf));
                        continue;
                    }
                    if (iYXCount > 0) {
                        explainDIItem(buf, iYXCount, NOT_WITH_TIME, command, meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                    if (iYCCount > 0) {
                        explainAIItem(buf, iYCCount, NOT_WITH_TIME, command, meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                    if (iLJCount > 0) {
                        explainPIItem(buf, iLJCount, NOT_WITH_TIME, command, meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                }
                command.setStatus(STATUS_SUCCESS);
            }finally {
                ReferenceCountUtil.release(addBuf);
                ReferenceCountUtil.release(dateBuf);
            }
        }
    }

    private void decodeCallback(ByteBuf buf, DataCommand command) {
        int taskCount = buf.readUnsignedByte();
        ByteBuf addBuf = null;
        ByteBuf dateBuf = null;
        for (int i = 0; i < taskCount; i++) {
            try {
                addBuf = buf.readBytes(6);
                String meterAddr = toLittleEndianHex(addBuf).toUpperCase();
                int itemCount = buf.order(ByteOrder.LITTLE_ENDIAN).readUnsignedShort();
                DataItem groupItem = explainGroupItem(i + 1, itemCount, command, meterAddr, STYPE_UP_FROZENDATA);
                for (int j = 0; j < itemCount; j++) {
                    dateBuf = buf.readBytes(7);
                    Date date = parseDataTime(dateBuf);
                    // 开入点数
                    int iYXCount = buf.readUnsignedByte();
                    // 模入点数
                    int iYCCount = buf.readUnsignedByte();
                    // 电度数据
                    int iLJCount = buf.readUnsignedByte();
                    int readableBytes = buf.readableBytes();
                    if (readableBytes < (iYXCount * 5 + iYCCount * 8 + iLJCount * 12)) {
                        log.error("DataArea Length is not Enough,DCU:{},Data:{}",
                            command.getRtuId(), ByteBufUtil.hexDump(buf));
                        continue;
                    }
                    if (iYXCount > 0) {
                        explainDIItem(buf, iYXCount, NOT_WITH_TIME, groupItem.getItemCommand(),
                            meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                    if (iYCCount > 0) {
                        explainAIItem(buf, iYCCount, NOT_WITH_TIME, groupItem.getItemCommand(),
                            meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                    if (iLJCount > 0) {
                        explainPIItem(buf, iLJCount, NOT_WITH_TIME, groupItem.getItemCommand(),
                            meterAddr, date, STYPE_UP_FROZENDATA);
                    }
                }
                command.setStatus(STATUS_SUCCESS);
            }finally {
                ReferenceCountUtil.release(addBuf);
                ReferenceCountUtil.release(dateBuf);
            }
        }
    }

    protected DataItem explainGroupItem(int taskIdx, int itemCount, DataCommand command, String addr, String code) {
        DataItem result = new DataItem();
        result.setCot(command.getCot());
        result.setCode(code);
        result.setTn(String.valueOf(itemCount));
        result.setValue(String.valueOf(taskIdx));
        result.setChannel(addr);
        result.setItemCommand(new DataCommand(command.getFunction(), (short) taskIdx, command.getRtuId()));
        result.setStatus(ITEM_STATUS_SUCCESS);
        command.addItem(result);
        return result;
    }

}
