package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_CONFIRM;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_REPLY;


class X27DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        ByteBuf byteBuf = null;
        if (command.getCot() == ASDU_COT_REPLY || command.getCot() == ASDU_COT_CONFIRM) {
            try {
                short size = buf.readUnsignedByte();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < size; i++) {
                    if (i > 0) {
                        sb.append('$');
                    }
                    byteBuf = buf.readBytes(6);
                    sb.append(toLittleEndianHex(byteBuf).toUpperCase());
                    sb.append('#').append(buf.readUnsignedByte());
                    sb.append('#').append(buf.readUnsignedByte());
                }
                setSuccessDataItem(command, sb.toString());
            }finally {
                ReferenceCountUtil.release(byteBuf);
            }
        } else {
            log.warn("Cot[" + HexDump.toHex(command.getCot()) + "] return,no more Content.");
            setFailedDataItem(command);
        }
    }

}
