package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.DCU_UNENCRYPT;


class X82DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        if (StringUtils.hasText(command.getCode())) {
            if (command.getCode().equals(DCU_UNENCRYPT)) {
                command.setCode(null);
            }
        }
        setSuccessDataItem(command, "");
    }

}
