package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.ASDU_COT_REPLY;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.BYTE_ORDER;


class X83DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        ByteBuf sValueBuf = null;
        if (command.getCot() == ASDU_COT_REPLY) {
            byte size = buf.readByte();
            if (readableBytes == size * 6 + 1) {
                try {
                    String sValue = String.valueOf(size);
                    for (int j = 0; j < size; j++) {
                        sValueBuf = buf.readBytes(4);
                        sValue += "#" + toLittleEndianHex(sValueBuf).toUpperCase();
                        sValue += "#" + buf.order(BYTE_ORDER).readShort();
                    }
                    setSuccessDataItem(command, sValue);
                }finally {
                    ReferenceCountUtil.release(sValueBuf);
                }
            } else {
                log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
            }
        } else {
            log.warn("Cot[" + HexDump.toHex(command.getCot()) + "] return,no more Content.");
            setFailedDataItem(command);
        }
    }

}
