package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;


import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class X86DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            setSuccessDataItem(command, "");
        } else {
            log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
        }
    }

}
