package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.cjt188.v2004.read.MBusReader;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.PARAM_LEN;

class XF9DataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) throws Exception{
        int readableBytes = buf.readableBytes();
        ByteBuf param = null;
        ByteBuf dataBuf = null;
        if (readableBytes > 4) {
            try {
                param = buf.readBytes(PARAM_LEN);
                dataBuf = buf.readBytes(readableBytes - 4);
                if(dataBuf.readableBytes() > 0){
                    ////解析m_bus协议  按照表类型进行分别解析
                        MBusReader mBusReader = new MBusReader();
                        MBus mBus = mBusReader.decode(dataBuf);
                        if (mBus != null) {
                            setF9SuccessDataItem(command, mBus, ByteBufUtil.hexDump(dataBuf).trim().toUpperCase(), param);
                        } else {
                            log.error("mBus解析失败，抛弃这条报文");
                        }
                    }
            }finally {
                ReferenceCountUtil.release(param);
                ReferenceCountUtil.release(dataBuf);
            }
        } else {
            log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
        }
    }
}
