package com.easesource.iot.protoparser.gaeadcu.handler.codec.decoder;

import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.CustFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.BYTE_ORDER;


class XFBDataItemDecoder extends BaseDataItemDecoder {
    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void decode(ByteBuf buf, DataCommand command) {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 12) {
            DataItem dataItem = setSuccessDataItem(command, "");
//            dataItem.setAttribute("FILE_ID", buf.order(BYTE_ORDER).readInt());
//            dataItem.setAttribute("START_POS", buf.order(BYTE_ORDER).readInt());
//            dataItem.setAttribute("READ_LEN", buf.order(BYTE_ORDER).readInt());
            CustFile file = new CustFile();
            file.setFileId(buf.order(BYTE_ORDER).readInt());
            file.setStartPos(buf.order(BYTE_ORDER).readInt());
            file.setReadLen(buf.order(BYTE_ORDER).readInt());
            dataItem.setFile(file);
        } else {
            log.error("ASDU Length:" + readableBytes + " Error,Data:" + ByteBufUtil.hexDump(buf));
        }
    }
}
