package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RequestEncoder {
    private static final Map<Byte, BaseRequestEncoder> encoderMap = new ConcurrentHashMap<Byte, BaseRequestEncoder>();
    private final Logger log = LoggerFactory.getLogger(getClass());

    public synchronized BaseRequestEncoder getRequestEncoder(byte type) {
        if (!encoderMap.containsKey(type)) {
            String className = getClass().getPackage().getName() + ".X" + HexDump.toHex(type) + "RequestEncoder";
            try {
                Class<BaseRequestEncoder> clazz = (Class<BaseRequestEncoder>) Class.forName(className);
                BaseRequestEncoder encoder = clazz.newInstance();
                encoderMap.put(type, encoder);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return encoderMap.get(type);
    }

    public DcuMessage encode(byte type,List<DataItem> dataItems, DataCommand cmd, DcuMessage msg){
        BaseRequestEncoder encoder;
        encoder = getRequestEncoder(type);
        return encoder.assemblyMessage(dataItems,cmd,msg);
    }

}
