package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.ParseUtils;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.Date;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X02RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        byte[] dataByte = new byte[X02DATA_LEN];
        //dataItem为1
        DataItem dataItem = dataItems.get(0);
        Date date = dataItem.getTime();
        //asdu:type,cot,time
        byte[] dcuData = {TYPE_CHECKTIME,COT_ACTIVE};

        byte[] dateBytes = ParseUtils.dateToByte(date);
        dateBytes[5]+=1;
        dataByte = BytesUtil.byteMerger(dcuData,dateBytes);
        msg.setData(dataByte);
        return msg;
    }
}
