package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X03RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = new byte[X03DATA_LEN];
        //dataItem为1
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,meter_id,point_id,cmd
        byte[] dcuData = {TYPE_SET_YK_COMMAND,COT_ACTIVE};
        byte[] channel = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel()));
        byte[] tn = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getTn()));
        byte[] commandValue = BytesUtil.stringToByte(dataItem.getValue());
        data = BytesUtil.byte4Merger(dcuData,channel,tn,commandValue);
        msg.setData(data);
        return msg;
    }
}
