package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;

import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X05RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = new byte[X05DATA_LEN];
        ByteBuf buf = ByteBufAllocator.DEFAULT.directBuffer();
        try {
            //dataItem为1
            DataItem dataItem = dataItems.get(0);
            //asdu:type,cot,meter_id,point_id,cmd
//            byte[] dcuData = {TYPE_SET_YT_INT_COMMAND, COT_ACTIVE};
//            byte[] channel = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel()));
//            byte[] tn = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getTn()));
//            //这个字段占4个字节， 要求是long，却占8个字节 于是暂时改成int
//            byte[] commandValue = BytesUtil.byteToByte(BytesUtil.intToBytes(Integer.valueOf(dataItem.getValue())));
//            data = BytesUtil.byte4Merger(dcuData, channel, tn, commandValue);
            buf.writeByte(TYPE_SET_YT_INT_COMMAND);
            buf.writeByte(COT_ACTIVE);
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel())));
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getTn())));
            //这个字段占4个字节， 要求是long，却占8个字节 于是暂时改成int
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(Integer.valueOf(dataItem.getValue()))));
            buf.readBytes(data);
            msg.setData(data);
            return msg;
        }finally {
            ReferenceCountUtil.release(buf);
        }
    }

}
