package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X06RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分

        //dataItem为1
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,meter_id,point_id,cmd
        byte[] dcuData = {TYPE_SET_YT_STRING_COMMAND,COT_ACTIVE};
        byte[] channel = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel()));
        byte[] tn = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getTn()));
        short length = dataItem.getStringLen();
        byte[] len = BytesUtil.byteToByte(BytesUtil.shortToBytes(length));
        //未验证正确性
        byte[] commandValue = BytesUtil.ASCIIToBytes(dataItem.getValue());

        byte[] data4 = BytesUtil.byte4Merger(dcuData,channel,tn,len);
        byte[] data = BytesUtil.byteMerger(data4,commandValue);
        msg.setData(data);
        return msg;
    }

}
