package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X21RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = new byte[X21DATA_LEN];
        //
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,meteraddr,group
        byte[] dcuData = new byte[]{TYPE_GETSELECTEDGROUP,COT_ASK};
        byte[] channel = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel()));
        //保存为字节数组 ，有待改正
        byte[] goupNumber = {dataItem.getGroupNumber()};
        data = BytesUtil.byte3Merger(dcuData,channel,goupNumber);
        msg.setData(data);
        return msg;
    }

}
