package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.Task;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X22RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        byte[] taskBytes = {};
        DataItem dataItem = dataItems.get(0);
        byte num = dataItem.getTaskNum();
        //asdu:type,cot,taskNum,{Task,.....}
        byte[] dcuData = new byte[]{TYPE_SET_FROZENTASK,COT_ASK,num};
        for(int i=0;i<num;i++){
            Task task = dataItems.get(i).getTask();
            byte[] meterId = BytesUtil.byteToByte(BytesUtil.stringToByte(task.getMeterId()));
            byte[] taskData = {task.getTaskNo(),task.getFrozenParam(),task.getSendPatram(),task.getNum()};
            List<String> signList = task.getSignList();
            byte[] signSum = {};
            for(int j=0;j<task.getNum();j++){
                byte[] sign = BytesUtil.byteToByte(BytesUtil.stringToByte(signList.get(j)));
                signSum = BytesUtil.byteMerger(signSum,sign);
            }
            taskBytes = BytesUtil.byte3Merger(meterId,taskData,signSum);
        }
        data = BytesUtil.byteMerger(dcuData,taskBytes);
        msg.setData(data);
        return msg;
    }

}
