package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.base.utils.ParseUtils;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.Task;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X25RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        byte[] taskBytes = {};
        DataItem dataItem = dataItems.get(0);
        byte num = dataItem.getTaskNum();
        //asdu:type,cot,taskNum,{Task,.....}
        byte[] dcuData = new byte[]{TYPE_CALL_FROZENDATA,COT_ASK,num};
        for(int i=0;i<num;i++){
            Task task = dataItems.get(i).getTask();
            byte[] meterId = BytesUtil.byteToByte(BytesUtil.stringToByte(task.getMeterId()));
            byte[] taskNo = {task.getTaskNo()};
            byte[] startTime = ParseUtils.dateToByte(task.getStartTime());
            byte[] endTime = ParseUtils.dateToByte(task.getEndTime());
            byte[] interval = {task.getInterval()};
            taskBytes = BytesUtil.byte5Merger(meterId,taskNo,startTime,endTime,interval);
        }
        data = BytesUtil.byteMerger(dcuData,taskBytes);
        msg.setData(data);
        return msg;
    }

}
