package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X80RequestEncoder extends BaseRequestEncoder {



    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,meter_id
        byte[] dcuData = new byte[]{TYPE_CHECK_BY_WEB,COT_ACTIVE};
        byte[] channel = BytesUtil.byteToByte(BytesUtil.stringToByte(dataItem.getChannel()));
        data = BytesUtil.byteMerger(dcuData,channel);
        msg.setData(data);
        return msg;
    }

}
