package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X82RequestEncoder extends BaseRequestEncoder {



    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,meter_id
        byte[] dcuData = new byte[]{TYPE_SET_SECRETKEY,COT_ACTIVE,dataItem.getEncrypitype()};
        byte[] password = BytesUtil.ASCIIToBytes(dataItem.getPassWord());
        data = BytesUtil.byteMerger(dcuData,password);
        msg.setData(data);
        return msg;
    }

}
