package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X83RequestEncoder extends BaseRequestEncoder {



    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,conftype,conflength,content
        byte[] dcuData = new byte[]{TYPE_GETPARAM,dataItem.getCot(),dataItem.getConftype()};
        byte[] conflength = BytesUtil.byteToByte(BytesUtil.shortToBytes(dataItem.getConflength()));
        //未实验
        byte[] content = dataItem.getValue().getBytes();
        //
        data = BytesUtil.byte3Merger(dcuData,conflength,content);
        msg.setData(data);
        return msg;
    }

}
