package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.base.utils.BytesUtil.byte3Merger;
import static com.easesource.iot.protoparser.base.utils.BytesUtil.byteMerger;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class X86RequestEncoder extends BaseRequestEncoder {



    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = {};
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,num,{param.....}
        byte[] dcuData = new byte[]{TYPE_SETPARAM,COT_ASK,dataItem.getParamNum()};
        byte[] paramList = {};
        for(int i = 0;i < dataItems.size() ; i++){
            //编码00000001 是否倒置
            byte[] param = BytesUtil.byteToByte(BytesUtil.intTotn4Bytes(dataItems.get(i).getParam()));
            byte[] value = BytesUtil.byteToByte(BytesUtil.shortToBytes(dataItems.get(i).getParamShort()));
            paramList = byte3Merger(paramList,param,value);
        }
        data = byteMerger(dcuData,paramList);
        msg.setData(data);
        return msg;
    }

}
