package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class XF8RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = new byte[XF8DATA_LEN];
        DataItem dataItem = dataItems.get(0);
        //asdu:type,cot,port,duration
        byte[] dcuData = new byte[]{TYPE_REVERSEPROXY,COT_ACTIVE};
        byte[] port = BytesUtil.byteToByte(BytesUtil.shortToBytes(dataItem.getPort()));
        byte[] duration = BytesUtil.byteToByte(BytesUtil.intToBytes(dataItem.getDuration()));
        data = BytesUtil.byte3Merger(dcuData,port,duration);
        msg.setData(data);
        return msg;
    }

}
