package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.cjt188.v2004.write.MBusWriter;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class XF9RequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data ;
        byte[] message ;
        //dataItem为1
        DataItem dataItem = dataItems.get(0);
        byte[] dcuData = {F9_BYTE,cmd.getCot(),dataItem.getPortName(),dataItem.getBaudRate(),dataItem.getParity(),dataItem.getStopBites()};
        if(dataItem.getValue() == null){
            //mbus组装
            MBusWriter mBusWriter = new MBusWriter();
            message = mBusWriter.encode(dataItem.getmBus());
        }else {
            //先校验一下value 是否是hexString
            message = BytesUtil.checkAndHexStringTobytes(dataItem.getValue());
        }
        //数组的拼接
        data = BytesUtil.byteMerger(dcuData,message);
        msg.setData(data);
        return msg;
    }
}
