package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.commons.util.StringUtils;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.base.utils.FileUtil;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.CustFile;
import com.easesource.iot.protoparser.gaeadcu.util.SecurityUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class XFARequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data = new byte[XFADATA_LEN];
        ByteBuf buf = ByteBufAllocator.DEFAULT.directBuffer();
        try {
            DataItem dataItem = dataItems.get(0);
            CustFile file = dataItem.getFile();
            //asdu:type,cot..
            buf.writeByte(TYPE_EMT621_UPDATE);
            buf.writeByte(COT_ACTIVE);
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(file.getFileId())));
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(file.getFileSize())));
            //不需要反向
            buf.writeBytes(file.getReadContent());
            buf.writeBytes(BytesUtil.ASCIIToBytes(file.getFileVersion()));
            buf.writeBytes(BytesUtil.ASCIIToBytes(file.getFileName()));
            buf.readBytes(data);
            msg.setData(data);
            return msg;
        }finally {
            ReferenceCountUtil.release(buf);
        }
    }
    public static void main(String[] args) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.directBuffer();
        int a = 213;
        int aa = 1;
        int aaa = 2;
        buf.writeByte(a);
        buf.writeInt(1);
        buf.writeByte(aa);
        buf.writeByte(aaa);
        try {
            buf.writeBytes(SecurityUtil.calculateMd5(FileUtil.readBytesFromFile("C:\\Users\\Administrator\\Documents\\WeChat Files\\wangzhibin5796\\FileStorage\\CustFile\\2019-11\\V5.25-EMT-621-24MHz.bin")));
        } catch (IOException e) {
            e.printStackTrace();
        }
        byte[] b = new byte[buf.readableBytes()];
        buf.readBytes(b);
        System.out.println(b.length);
        for(byte c: b){
            System.out.println(c);
        }
    }
}
